CREATE PROCEDURE dbo.sp__ADMIN_CREATE_INSERTS
                     @TABLE_SCHEMA   sysname,
                     @TABLE_NAME     sysname,
                     @FORCE_IDENTITY BIT = 0
AS
-- Dclaration des variables locales
DECLARE @SQL          NVARCHAR(MAX),
        @ID_ON        NVARCHAR(MAX),
        @ID_OFF       NVARCHAR(MAX),
        @COLUMNS      NVARCHAR(MAX),
        @VALUES       NVARCHAR(MAX),
        @COL_IDENTITY sysname;
-- Assignations pralables
SELECT @COLUMNS = '', @VALUES = '';
-- Est-ce que la table existe ?
IF NOT EXISTS(SELECT *
              FROM   INFORMATION_SCHEMA.TABLES
              WHERE  TABLE_NAME = @TABLE_NAME
                AND  TABLE_SCHEMA = @TABLE_SCHEMA)
BEGIN
   RAISERROR('La table %s.%s n''a pas t trouve.', 16, 1, @TABLE_SCHEMA, @TABLE_NAME);
RETURN;
END;

-- Rcupre la colonne auto-incrmente IDENTITY si elle existe dans la table
SELECT @COL_IDENTITY = COLUMN_NAME
FROM   INFORMATION_SCHEMA.COLUMNS
WHERE  COLUMNPROPERTY(OBJECT_ID(DB_NAME() + '.' + TABLE_SCHEMA +'.' + TABLE_NAME), COLUMN_NAME, 'IsIdentity') = 1
  AND  TABLE_NAME = @TABLE_NAME
  AND  TABLE_SCHEMA = @TABLE_SCHEMA;
SET @COL_IDENTITY = COALESCE(@COL_IDENTITY, '');
-- Si lon a demand le forage des auto-incrments et quil y a une telle colonne, alors prparer la commande IDENTITY_INSERT ON/OFF
IF @FORCE_IDENTITY = 1 AND @COL_IDENTITY <> ''
BEGIN
   SET @ID_ON = 'SELECT 0 AS O, ''SET IDENTITY_INSERT ['
              + DB_NAME() +'].[' 
			  + @TABLE_SCHEMA +'].['
              + @TABLE_NAME + '] ON; '' AS C UNION ALL '
   SET @ID_OFF = ' UNION ALL SELECT 2, ''SET IDENTITY_INSERT ['
               + DB_NAME() +'].[' 
			   + @TABLE_SCHEMA +'].['
			   + @TABLE_NAME
               + '] OFF; '''
   SET @COL_IDENTITY = '';
END
ELSE
   SELECT @ID_ON = '', @ID_OFF = '';
-- Cration de la liste des colonnes et des valeurs converties en hexadcimal
SELECT @COLUMNS = @COLUMNS + ',' + '[' + COLUMN_NAME + ']',
       @VALUES = @VALUES
               + '+'',''+COALESCE(master.dbo.fn_varbintohexstr(cast(['
               + COLUMN_NAME + '] as varbinary(max))),''NULL'')'
FROM   INFORMATION_SCHEMA.COLUMNS
WHERE  TABLE_NAME = @TABLE_NAME
  AND  TABLE_SCHEMA = @TABLE_SCHEMA
  AND  DATA_TYPE NOT IN ('timestamp', 'rowversion')
  AND  COLUMN_NAME <> @COL_IDENTITY
  AND  COLUMN_NAME NOT IN -- On vite les colonnes calcules
       (SELECT COLUMN_NAME
        FROM   INFORMATION_SCHEMA.COLUMNS
        WHERE  TABLE_NAME = @TABLE_NAME
          AND  TABLE_SCHEMA = @TABLE_SCHEMA
          AND  COLUMNPROPERTY(OBJECT_ID(DB_NAME() + '.' + TABLE_SCHEMA +'.' + TABLE_NAME), COLUMN_NAME, 'isComputed') = 1);
-- Construction de la commande SQL INSERT INTO
SET @SQL = @ID_ON + 'SELECT 1 AS O, ''INSERT INTO [' + DB_NAME()
         + '].[' + @TABLE_SCHEMA +'].['+@TABLE_NAME + '] ('
         + SUBSTRING(@COLUMNS, 2, LEN(@COLUMNS)) + ') '
         + 'VALUES (''+' + SUBSTRING(@VALUES, 6, LEN(@VALUES))
         + '+'')'' AS C FROM [' + @TABLE_SCHEMA +'].['+ @TABLE_NAME +']'
         + @ID_OFF;
SET @SQL = 'SELECT C FROM (' + @SQL +') AS T ORDER BY O;';
-- Lance la commande SQL
EXEC sp_executesql @SQL;
